#ifndef DCOLOR_H
    #define DCOLOR_H

    #include "DObjeto.h"

    #ifndef RGB
        #define RGB(nR, nG, nB)          ((COLORREF)(((ULONG) (nB) << 0) | ((ULONG) (nG) << 8) | ((ULONG) (nR) << 16) | ((ULONG) (255) << 24)))
    #endif

    #ifndef RGBA
        #define RGBA(nR, nG, nB, nA)     ((COLORREF)(((ULONG) (nB) << 0) | ((ULONG) (nG) << 8) | ((ULONG) (nR) << 16) | ((ULONG) (nA) << 24)))
    #endif

    namespace DWL {

        class DColor : public DObjeto {
          public:
                                        DColor(void)                                                                : _Color(0) { };
                                        DColor(const DColor &nColor)                                                : _Color(nColor._Color) { };
                                        DColor(const COLORREF nColor)                                               : _Color(nColor) { };
                                        DColor(const BYTE nR, const BYTE nG, const BYTE nB, const BYTE nA = 255)    : _Color(RGBA(nR, nG, nB, nA)) { };

            inline const COLORREF       Color(void)                                                                 { return _Color; };
            inline void                 Color(const DColor &nColor)                                                 { _Color = nColor._Color; };
            inline void                 Color(const COLORREF nColor)                                                { _Color = nColor; };
            inline void                 Color(const BYTE nR, const BYTE nG, const BYTE nB, const BYTE nA = 255)     { _Color = RGBA(nR, nG, nB, nA); };
        
            inline const COLORREF       operator() (void)                                                           { return _Color; };
            inline const DColor        &operator = (const DColor &nColor)                                           { _Color = nColor._Color; return *this; };
            inline const DColor        &operator = (const COLORREF nColor)                                          { _Color = nColor; return *this; };
            inline const bool           operator == (const DColor &nColor)                                          { return (_Color == nColor._Color); };
            inline const bool           operator == (const COLORREF nColor)                                         { return (_Color == nColor); };
            inline const bool           operator != (const DColor &nColor)                                          { return (_Color != nColor._Color); };
            inline const bool           operator != (const COLORREF nColor)                                         { return (_Color != nColor); };

            inline void                 R(BYTE nR)                                                                  { _Color = RGBA(nR, G(), B(), A()); };
            inline const BYTE           R(void)                                                                     { return static_cast<BYTE>(_Color >> 16); };
            inline void                 G(BYTE nG)                                                                  { _Color = RGBA(R(), nG, B(), A()); };
            inline const BYTE           G(void)                                                                     { return static_cast<BYTE>(_Color >> 8); };
            inline void                 B(BYTE nB)                                                                  { _Color = RGBA(R(), G(), nB, A()); };
            inline const BYTE           B(void)                                                                     { return static_cast<BYTE>(_Color >> 0); };
            inline void                 A(BYTE nA)                                                                  { _Color = RGBA(R(), G(), B(), nA); };
            inline const BYTE           A(void)                                                                     { return static_cast<BYTE>(_Color >> 24); };

            //////////////////////////////// DObjeto
            virtual const TCHAR        *Objeto_Nombre(void) { return TEXT("DBoton_Color"); };
            virtual const DEnum_Objeto  Objeto_ID(void)     { return DEnum_Objeto_Color; };

          protected :
            COLORREF                   _Color;
        };

    };

#endif